;;; -*- Mode: Common-Lisp; Package: User; Base: 10.; Patch-File: T -*-
;;; Written 07/03/89 14:33:40 by GRENINGER,
;;; Reason: Turn off, but remember, crosshair cursor mode while a command is executing,
;;; turn it back on when the command is finished if it was on initially.
;;; while running on MX23 from band g629
;;; With SYSTEM 6.10, GC 6.3, VIRTUAL-MEMORY 6.1, MICRONET 6.0, MICRONET-COMM 6.1,
;;;  DISK-IO 6.0, DISK-LABEL 6.0, BASIC-PATHNAME 6.0, MAC-PATHNAME 6.0, NETWORK-SUPPORT-COLD 6.0,
;;;  BASIC-NAMESPACE 6.1, BASIC-FILE 6.2, RPC 6.1, NFS-MX 6.0, EH 6.3, MAKE-SYSTEM 6.0,
;;;  MEMORY-AUX 6.0, COMPILER 6.6, Inconsistent TV 6.12, NVRAM 6.1, UCL 6.0, INPUT-EDITOR 6.0,
;;;  MACTOOLBOX 2.3, METER 6.1, ZWEI 6.3, Experimental DEBUG-TOOLS 6.3, Inconsistent WINDOW-MX 6.5,
;;;  PRINTER 6.2, MAC-PRINTER-TYPES 6.1, CLIPBOARD 6.0, TI-CLOS 6.9, CLEH 6.4, NETWORK-PATHNAME 6.0,
;;;  NETWORK-NAMESPACE 6.0, DATALINK 6.0, CHAOSNET 6.0, NETWORK-SUPPORT 6.0, NETWORK-SERVICE 6.1,
;;;  DATALINK-DISPLAYS 6.0, MX-DATALINK 6.1, NAMESPACE-EDITOR 6.0, IP 3.47, NFS-MX-SERVER 6.0,
;;;  MX-SERIAL 6.0, PRINTER-TYPES 6.0, IMAGEN 6.0, MAIL-DAEMON 6.2, MAIL-READER 6.0,
;;;  TELNET 6.0, VT100 6.0, STREAMER-TAPE 6.3, DECNET 1.69, VISIDOC 6.2, PROFILE 6.1,
;;;  Experimental GRAPHICS-WINDOW 6.0, Experimental GED 6.1,  microcode 138, Band Name: microExplorer Network (6/22)

#!C
; From file GED-UTILITY-METHODS.LISP#> GED; SYS:
#10R GED#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "GED"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: GED; GED-UTILITY-METHODS.#"


(defflavor ged-command
	   ((crosshair-cursor-mode nil))
	   (ucl::command)
  (:documentation "Command flavor for Graphics Editor commands")) 

))

#!C
; From file GED-UTILITY-METHODS.LISP#> GED; SYS:
#10R GED#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "GED"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: GED; GED-UTILITY-METHODS.#"


(defmethod (graphics-editor :chores-after-command) (crosshair-cursor-mode)
  "These commands are executed after a command.  The generic command
loop does not handle special GED blips, so this method may be called from
:handle-unknown-input as well as :after :handle-command.  It isn't at
present but may be if some command besides :variable-choice needs
to be handled separately and it needs these chores run."

  (send current-buffer :redraw-if-necessary self)
  (send current-buffer :redraw-grid-if-necessary)
  (when (eq (window-owning-mouse) g-pane)
    (send g-pane :mouse-standard-blinker)
    (WHEN crosshair-cursor-mode
      (send g-pane :turn-on-crosshair)))
  (send self :update-buffer-status)) 

))

#!C
; From file GED-UTILITY-METHODS.LISP#> GED; SYS:
#10R GED#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "GED"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: GED; GED-UTILITY-METHODS.#"


(defmethod (ged-command :before :execute) (ged-instance)
  (LET ((g-pane (send ged-instance :g-pane)))
    (WHEN (SETF crosshair-cursor-mode (SEND g-pane :crosshair-mode))
      (SEND g-pane :turn-off-crosshair))
    (send g-pane :suspend-crosshair)))

))

#!C
; From file GED-UTILITY-METHODS.LISP#> GED; SYS:
#10R GED#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "GED"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: GED; GED-UTILITY-METHODS.#"


(defmethod (ged-command :after :execute) (ged-instance)
  "Restore the graphics editor to its waiting-for-input state"
  
  (send ged-instance :chores-after-command crosshair-cursor-mode)) 

))

(COMPILE-FLAVOR-METHODS ged:ged-command ged:graphics-editor)

(LOAD "sys:ged;function-commands")
(LOAD "sys:ged;mode-commands")
(LOAD "sys:ged;mouse-move-commands")
(LOAD "sys:ged;picture-commands")
(LOAD "sys:ged;presentation-commands")
(LOAD "sys:ged;status-commands")
(LOAD "sys:ged;submenu-commands")
(LOAD "sys:ged;subpicture-commands")
(LOAD "sys:ged;windowing-commands")
(LOAD "sys:ged;build-command-tables")